using System;
using System.Collections;
using gov.va.med.vbecs.BOL;

namespace gov.va.med.vbecs.admin.GUI
{
	/// <summary>
	/// Class DlgEditUserParameters
	/// </summary>
	public class DlgEditUserParameters : gov.va.med.vbecs.admin.GUI.DlgAdminBase
	{
		private gov.va.med.vbecs.admin.GUI.EditVbecsUserParameters editVbecsUserParameters;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgEditUserParameters() : base()
		{
			this.LockController.LockFunction = Common.LockFunctions.MUC03_EditVbecsUserParameters;			
			InitializeComponent();
			gov.va.med.vbecs.Common.LogonUser.NotDefined = true;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		/// <summary>
		/// ConfirmDialogClosing
		/// </summary>
		/// <returns></returns>
		protected override bool ConfirmDialogClosing()
		{
			return editVbecsUserParameters.ConfirmExit();
		}

		/// <summary>
		/// SetLocksFromControl
		/// </summary>
		/// <param name="recordsToLock"></param>
		/// <returns></returns>
		public bool SetLocksFromControl( Guid[] recordsToLock )
		{
			return SetMUCLocks( recordsToLock );
		}

		/// <summary>
		/// ReleaseLocksFromControl
		/// </summary>
		/// <param name="recordsToRelease"></param>
		public void ReleaseLocksFromControl( Guid[] recordsToRelease )
		{
			ReleaseLocks( recordsToRelease );
		}

		/// <summary>
		/// ReleaseAllLocksFromControl
		/// </summary>
		public void ReleaseAllLocksFromControl( )
		{
			UnlockAllRecords();
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.editVbecsUserParameters = new gov.va.med.vbecs.admin.GUI.EditVbecsUserParameters();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(542, 30);
			this.vbecsLogo1.Title = "Edit VBECS User";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 478);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// editVbecsUserParameters
			// 
			this.editVbecsUserParameters.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.editVbecsUserParameters.Location = new System.Drawing.Point(3, 30);
			this.editVbecsUserParameters.Name = "editVbecsUserParameters";
			this.editVbecsUserParameters.Size = new System.Drawing.Size(538, 452);
			this.editVbecsUserParameters.TabIndex = 3;
			// 
			// DlgEditUserParameters
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(542, 494);
			this.Controls.Add(this.editVbecsUserParameters);
			this.MinimumSize = new System.Drawing.Size(550, 528);
			this.Name = "DlgEditUserParameters";
			this.RequiredFieldsLabel = true;
			this.Text = "VBECS - Edit User";
			this.Controls.SetChildIndex(this.editVbecsUserParameters, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.ResumeLayout(false);

			this.Closing += new System.ComponentModel.CancelEventHandler(DlgEditUserParameters_Closing);
		}
		#endregion

		private void DlgEditUserParameters_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			if (e.Cancel)
			{
				bool formSafeToClose = true;
				IList vbecsDivisionsList = DivisionDefinition.GetActiveVbecsDivisionsDefList();
			
				foreach(DivisionDefinition div in vbecsDivisionsList)
				{
					if (!this.editVbecsUserParameters.ActiveLevel6UserPresent(div.DivisionCode))
					{
						formSafeToClose = false;
					}																							
				}

				if (!formSafeToClose)
				{
					e.Cancel = true;
					gov.va.med.vbecs.GUI.GuiMessenger.ShowMessageBox( Common.StrRes.SysErrMsg.UC019.RemoveLastAdminUser() );
				}
			}
		}
	}
}

